/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;

public class LUDecomp {
    private LUDecomp() {
    }

    public static <BASETYPE, BASETYPE_ALGEBRA extends RingWithUnity<BASETYPE_ALGEBRA, BASETYPE> & Invertible<BASETYPE>, MATRIX_MEMBER extends MatrixMember<BASETYPE>, MATRIX_ALGEBRA extends Algebra<MATRIX_ALGEBRA, MATRIX_MEMBER> & Constructible2dLong<MATRIX_MEMBER>> void compute(BASETYPE_ALGEBRA numAlgebra, MATRIX_ALGEBRA matAlgebra, MATRIX_MEMBER a) {
        if (a.rows() != a.cols()) {
            throw new IllegalArgumentException("LUDecomp requires square matrix input");
        }
        long n = a.rows();
        MatrixMember lu = (MatrixMember)((Constructible2dLong<MATRIX_MEMBER>)matAlgebra).construct(a.storageType(), n, n);
        Object sum = numAlgebra.construct();
        Object value1 = numAlgebra.construct();
        Object value2 = numAlgebra.construct();
        Object term = numAlgebra.construct();
        Object tmp = numAlgebra.construct();
        for (long i = 0L; i < n; ++i) {
            long k;
            long j;
            for (j = i; j < n; ++j) {
                numAlgebra.zero().call(sum);
                for (k = 0L; k < i; ++k) {
                    lu.v(i, k, value1);
                    lu.v(k, j, value2);
                    numAlgebra.multiply().call(value1, value2, term);
                    numAlgebra.add().call(sum, term, sum);
                }
                a.v(i, j, term);
                numAlgebra.subtract().call(term, sum, term);
                lu.setV(i, j, term);
            }
            for (j = i + 1L; j < n; ++j) {
                numAlgebra.zero().call(sum);
                for (k = 0L; k < i; ++k) {
                    lu.v(j, k, value1);
                    lu.v(k, i, value2);
                    numAlgebra.multiply().call(value1, value2, term);
                    numAlgebra.add().call(sum, term, sum);
                }
                numAlgebra.unity().call(value1);
                lu.v(i, i, tmp);
                ((Invertible<BASETYPE>)numAlgebra).divide().call(value1, tmp, value1);
                a.v(j, i, tmp);
                numAlgebra.subtract().call(tmp, sum, value2);
                numAlgebra.multiply().call(value1, value2, term);
                lu.setV(j, i, term);
            }
        }
        matAlgebra.assign().call(lu, a);
    }
}

