/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.RightRotate;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class LeftRotate {
    private LeftRotate() {
    }

    public static <T extends Algebra<T, U>, U> void compute(T algebra, long delta, IndexedDataSource<U> a) {
        long aSize = a.size();
        if (aSize == 0L) {
            return;
        }
        if (delta < 0L) {
            RightRotate.compute(algebra, Math.abs(delta), a);
            return;
        }
        if ((delta %= aSize) == 0L) {
            return;
        }
        Object tmp1 = algebra.construct();
        Object tmp2 = algebra.construct();
        long n = aSize;
        for (long i = 0L; i < LeftRotate.gcd(delta, n); ++i) {
            a.get(i, tmp1);
            long j = i;
            while (true) {
                long k;
                if ((k = j + delta) >= n) {
                    k -= n;
                }
                if (k == i) break;
                a.get(k, tmp2);
                a.set(j, tmp2);
                j = k;
            }
            a.set(j, tmp1);
        }
    }

    private static long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return LeftRotate.gcd(b, a % b);
    }
}

