/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class LexicographicalCompare {
    private LexicographicalCompare() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> boolean compute(T alg, IndexedDataSource<U> a, IndexedDataSource<U> b) {
        long aSize = a.size();
        long bSize = b.size();
        long minSize = Math.min(aSize, bSize);
        Object tmpA = alg.construct();
        Object tmpB = alg.construct();
        for (long i = 0L; i < minSize; ++i) {
            a.get(i, tmpA);
            b.get(i, tmpB);
            if (((Ordered<U>)alg).isLess().call(tmpA, tmpB).booleanValue()) {
                return true;
            }
            if (!((Ordered<U>)alg).isGreater().call(tmpA, tmpB).booleanValue()) continue;
            return false;
        }
        return aSize < bSize;
    }
}

