/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.predicate.Predicate;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class LowerBound {
    private LowerBound() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> long compute(T alg, U val, IndexedDataSource<U> a) {
        Object value = alg.construct();
        long first = 0L;
        long last = a.size();
        long count = last - first;
        while (count > 0L) {
            long it = first;
            long step = count / 2L;
            a.get(it += step, value);
            if (((Ordered<U>)alg).isLess().call(value, val).booleanValue()) {
                first = ++it;
                count -= step + 1L;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static <T extends Algebra<T, U>, U> long compute(T alg, U val, Predicate<Tuple2<U, U>> isLess, IndexedDataSource<U> a) {
        Object value = alg.construct();
        Tuple2 tuple = new Tuple2(val, value);
        long first = 0L;
        long last = a.size();
        long count = last - first;
        while (count > 0L) {
            long it = first;
            long step = count / 2L;
            a.get(it += step, value);
            if (!isLess.isTrue(tuple)) {
                first = ++it;
                count -= step + 1L;
                continue;
            }
            count = step;
        }
        return first;
    }
}

