/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.LUDecomp;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;

public class MatrixDeterminant {
    private MatrixDeterminant() {
    }

    public static <BASETYPE, BASETYPE_ALGEBRA extends RingWithUnity<BASETYPE_ALGEBRA, BASETYPE> & Invertible<BASETYPE>, MATRIX_MEMBER extends MatrixMember<BASETYPE>, MATRIX_ALGEBRA extends Algebra<MATRIX_ALGEBRA, MATRIX_MEMBER> & Constructible2dLong<MATRIX_MEMBER>> void compute(MATRIX_ALGEBRA matAlgebra, BASETYPE_ALGEBRA numAlgebra, MATRIX_MEMBER a, BASETYPE det) {
        if (a.rows() != a.cols()) {
            throw new IllegalArgumentException("determinant requires square matrix");
        }
        MATRIX_MEMBER tmpMat = matAlgebra.construct(a);
        LUDecomp.compute(numAlgebra, matAlgebra, tmpMat);
        Object tmp = numAlgebra.construct();
        Object prod = numAlgebra.construct();
        numAlgebra.unity().call(prod);
        for (long i = 0L; i < tmpMat.rows(); ++i) {
            tmpMat.v(i, i, tmp);
            numAlgebra.multiply().call(prod, tmp, prod);
        }
        numAlgebra.assign().call(prod, det);
    }
}

