/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.Multiplication;

public class MatrixDirectProduct {
    private MatrixDirectProduct() {
    }

    public static <T extends Algebra<T, U> & Multiplication<U>, U, W extends MatrixMember<U>> void compute(T algebra, W in1, W in2, W out) {
        Object tmp1 = algebra.construct();
        Object tmp2 = algebra.construct();
        Object tmp3 = algebra.construct();
        if (out == in1 || out == in2) {
            throw new IllegalArgumentException("output matrix must not be one of input matrices");
        }
        out.alloc(in1.rows() * in2.rows(), in1.cols() * in2.cols());
        for (long r1 = 0L; r1 < in1.rows(); ++r1) {
            for (long c1 = 0L; c1 < in1.cols(); ++c1) {
                in1.v(r1, c1, tmp1);
                for (long r2 = 0L; r2 < in2.rows(); ++r2) {
                    for (long c2 = 0L; c2 < in2.cols(); ++c2) {
                        in2.v(r2, c2, tmp2);
                        ((Multiplication<U>)algebra).multiply().call(tmp1, tmp2, tmp3);
                        out.setV(r1 * in2.rows() + r2, c1 * in2.cols() + c2, tmp3);
                    }
                }
            }
        }
    }
}

