/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;

public class MatrixEqual {
    private MatrixEqual() {
    }

    public static <T extends Algebra<T, U>, U> boolean compute(T algebra, MatrixMember<U> a, MatrixMember<U> b) {
        if (a == b) {
            return true;
        }
        if (a.rows() != b.rows()) {
            return false;
        }
        if (a.cols() != b.cols()) {
            return false;
        }
        Object value1 = algebra.construct();
        Object value2 = algebra.construct();
        for (long r = 0L; r < a.rows(); ++r) {
            for (long c = 0L; c < a.cols(); ++c) {
                a.v(r, c, value1);
                b.v(r, c, value2);
                if (!algebra.isNotEqual().call(value1, value2).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }
}

