/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.LUDecomp;
import nom.bdezonia.zorbage.algorithm.LUSolve;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.RModule;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.ctor.Constructible1dLong;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.data.helper.MatrixColumnRModuleBridge;

public class MatrixInvert {
    private MatrixInvert() {
    }

    public static <BASETYPE, BASETYPE_ALGEBRA extends RingWithUnity<BASETYPE_ALGEBRA, BASETYPE> & Invertible<BASETYPE>, RMODULE_MEMBER extends RModuleMember<BASETYPE>, RMODULE_ALGEBRA extends RModule<RMODULE_ALGEBRA, RMODULE_MEMBER, BASETYPE_ALGEBRA, BASETYPE> & Constructible1dLong<RMODULE_MEMBER>, MATRIX_MEMBER extends MatrixMember<BASETYPE>, MATRIX_ALGEBRA extends Algebra<MATRIX_ALGEBRA, MATRIX_MEMBER> & Constructible2dLong<MATRIX_MEMBER>> void compute(BASETYPE_ALGEBRA numAlgebra, RMODULE_ALGEBRA rmodAlgebra, MATRIX_ALGEBRA matAlgebra, MATRIX_MEMBER a, MATRIX_MEMBER b) {
        if (a.rows() != a.cols()) {
            throw new IllegalArgumentException("can only invert square matrices");
        }
        if (a.rows() != b.rows() || a.cols() != b.cols()) {
            b.alloc(a.rows(), a.cols());
        }
        MATRIX_MEMBER lu = matAlgebra.construct(a);
        LUDecomp.compute(numAlgebra, matAlgebra, lu);
        RModuleMember bCol = (RModuleMember)((Constructible1dLong<RMODULE_MEMBER>)rmodAlgebra).construct(b.storageType(), b.rows());
        MatrixColumnRModuleBridge xBridge = new MatrixColumnRModuleBridge(numAlgebra, b);
        Object zero = numAlgebra.construct();
        Object one = numAlgebra.construct();
        numAlgebra.unity().call(one);
        for (long c = 0L; c < b.cols(); ++c) {
            xBridge.setCol(c);
            bCol.setV(c, one);
            LUSolve.compute(numAlgebra, rmodAlgebra, lu, bCol, xBridge);
            bCol.setV(c, zero);
        }
    }
}

