/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.Multiplication;

public class MatrixMultiply {
    private MatrixMultiply() {
    }

    public static <T extends Algebra<T, U> & Addition<U>, U> void compute(T algebra, MatrixMember<U> a, MatrixMember<U> b, MatrixMember<U> c) {
        if (c == a || c == b) {
            throw new IllegalArgumentException("dangerous matrix multiply definition");
        }
        if (a.cols() != b.rows()) {
            throw new IllegalArgumentException("incompatible matrix shapes in matrix multiply");
        }
        long rows = a.rows();
        long cols = b.cols();
        long common = a.cols();
        c.alloc(rows, cols);
        Object sum = algebra.construct();
        Object atmp = algebra.construct();
        Object btmp = algebra.construct();
        Object term = algebra.construct();
        for (long row = 0L; row < rows; ++row) {
            for (long col = 0L; col < cols; ++col) {
                algebra.zero().call(sum);
                for (long i = 0L; i < common; ++i) {
                    a.v(row, i, atmp);
                    b.v(i, col, btmp);
                    ((Multiplication)algebra).multiply().call(atmp, btmp, term);
                    ((Addition<U>)algebra).add().call(sum, term, sum);
                }
                c.setV(row, col, sum);
            }
        }
    }
}

