/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.RModule;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.ctor.Constructible1dLong;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;

public class MatrixPower {
    private MatrixPower() {
    }

    public static <BASETYPE, BASETYPE_ALGEBRA extends RingWithUnity<BASETYPE_ALGEBRA, BASETYPE> & Invertible<BASETYPE>, RMODULE_MEMBER extends RModuleMember<BASETYPE>, RMODULE_ALGEBRA extends RModule<RMODULE_ALGEBRA, RMODULE_MEMBER, BASETYPE_ALGEBRA, BASETYPE> & Constructible1dLong<RMODULE_MEMBER>, MATRIX_MEMBER extends MatrixMember<BASETYPE>, MATRIX_ALGEBRA extends Algebra<MATRIX_ALGEBRA, MATRIX_MEMBER> & Constructible2dLong<MATRIX_MEMBER>> void compute(int power, BASETYPE_ALGEBRA numAlgebra, RMODULE_ALGEBRA rmodAlgebra, MATRIX_ALGEBRA matAlgebra, MATRIX_MEMBER a, MATRIX_MEMBER b) {
        if (a.rows() != a.cols()) {
            throw new IllegalArgumentException("power requires a square matrix as input");
        }
        if (power < 0) {
            MatrixMember aInv = (MatrixMember)matAlgebra.construct();
            MatrixInvert.compute(numAlgebra, rmodAlgebra, matAlgebra, a, aInv);
            MatrixPower.compute(-power, numAlgebra, rmodAlgebra, matAlgebra, aInv, b);
        } else if (power == 0) {
            b.alloc(a.rows(), a.cols());
            if (matAlgebra.isZero().call(a).booleanValue()) {
                throw new IllegalArgumentException("0^0 is not a number");
            }
            MatrixUnity.compute(numAlgebra, b);
        } else if (power == 1) {
            MatrixAssign.compute(numAlgebra, a, b);
        } else {
            MATRIX_MEMBER p = matAlgebra.construct(a);
            MatrixMember tmp = (MatrixMember)matAlgebra.construct();
            int i = 0;
            while ((power & 1 << i) == 0) {
                MatrixMultiply.compute(numAlgebra, p, p, tmp);
                MatrixAssign.compute(numAlgebra, tmp, p);
                ++i;
            }
            MATRIX_MEMBER x = matAlgebra.construct(p);
            int maxBit = Integer.highestOneBit(power);
            for (int j = i + 1; j <= maxBit; ++j) {
                MatrixMultiply.compute(numAlgebra, p, p, tmp);
                MatrixAssign.compute(numAlgebra, tmp, p);
                if ((power & 1 << j) <= 0) continue;
                MatrixMultiply.compute(numAlgebra, x, p, tmp);
                MatrixAssign.compute(numAlgebra, tmp, x);
            }
            MatrixAssign.compute(numAlgebra, x, b);
        }
    }
}

