/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;

public class MatrixSubtraction {
    private MatrixSubtraction() {
    }

    public static <T extends Algebra<T, U> & Addition<U>, U> void compute(T algebra, MatrixMember<U> a, MatrixMember<U> b, MatrixMember<U> c) {
        if (a.rows() != b.rows()) {
            throw new IllegalArgumentException("cannot subtract matrices of different shapes");
        }
        if (a.cols() != b.cols()) {
            throw new IllegalArgumentException("cannot subtract matrices of different shapes");
        }
        if (c != a && c != b) {
            c.alloc(a.rows(), a.cols());
        }
        Object atmp = algebra.construct();
        Object btmp = algebra.construct();
        Object tmp = algebra.construct();
        for (long row = 0L; row < a.rows(); ++row) {
            for (long col = 0L; col < a.cols(); ++col) {
                a.v(row, col, atmp);
                b.v(row, col, btmp);
                ((Addition<U>)algebra).subtract().call(atmp, btmp, tmp);
                c.setV(row, col, tmp);
            }
        }
    }
}

