/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;

public class MatrixTranspose {
    private MatrixTranspose() {
    }

    public static <T extends Algebra<T, U>, U> void compute(T algebra, MatrixMember<U> a, MatrixMember<U> b) {
        Object value1 = algebra.construct();
        Object value2 = algebra.construct();
        if (a == b) {
            if (a.rows() != a.cols()) {
                throw new IllegalArgumentException("in place transpose only works for square matrices");
            }
            for (long d = 1L; d < a.rows(); ++d) {
                for (long c = 1L; c <= d; ++c) {
                    a.v(d - c, d, value1);
                    a.v(d, d - c, value2);
                    a.setV(d - c, d, value2);
                    a.setV(d, d - c, value1);
                }
            }
        } else {
            b.alloc(a.cols(), a.rows());
            for (long r = 0L; r < a.rows(); ++r) {
                for (long c = 0L; c < a.cols(); ++c) {
                    a.v(r, c, value1);
                    b.setV(c, r, value1);
                }
            }
        }
    }
}

