/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.DeepCopy;
import nom.bdezonia.zorbage.algorithm.Sort;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class MedianValues {
    private MedianValues() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U extends Allocatable<U>> void compute(T alg, IndexedDataSource<U> storage, U result1, U result2) {
        IndexedDataSource<U> localStorage = DeepCopy.compute(alg, storage);
        Sort.compute(alg, localStorage);
        long localStorageSize = localStorage.size();
        if (localStorageSize == 0L) {
            Allocatable zero = (Allocatable)alg.construct();
            alg.assign().call(zero, result1);
            alg.assign().call(zero, result2);
        } else if (localStorageSize % 2L == 0L) {
            localStorage.get(localStorageSize / 2L - 1L, result1);
            localStorage.get(localStorageSize / 2L, result2);
        } else {
            localStorage.get(localStorageSize / 2L, result1);
            alg.assign().call(result1, result2);
        }
    }
}

