/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class Merge {
    private Merge() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> void compute(T alg, IndexedDataSource<U> a, IndexedDataSource<U> b, IndexedDataSource<U> c) {
        long cSize;
        long bSize;
        long aSize = a.size();
        if (aSize + (bSize = b.size()) != (cSize = c.size())) {
            throw new IllegalArgumentException("mismatched list sizes");
        }
        long ai = 0L;
        long bi = 0L;
        long ci = 0L;
        Object tmpA = alg.construct();
        Object tmpB = alg.construct();
        boolean mustLoadA = true;
        boolean mustLoadB = true;
        while (true) {
            if (ai >= aSize) {
                for (long i = bi; i < bSize; ++i) {
                    b.get(i, tmpB);
                    c.set(ci++, tmpB);
                }
                return;
            }
            if (bi >= bSize) {
                for (long i = ai; i < aSize; ++i) {
                    a.get(i, tmpA);
                    c.set(ci++, tmpA);
                }
                return;
            }
            if (mustLoadA) {
                a.get(ai, tmpA);
                mustLoadA = false;
            }
            if (mustLoadB) {
                b.get(bi, tmpB);
                mustLoadB = false;
            }
            if (((Ordered<U>)alg).isLess().call(tmpB, tmpA).booleanValue()) {
                ++bi;
                c.set(ci++, tmpB);
                mustLoadB = true;
                continue;
            }
            ++ai;
            c.set(ci++, tmpA);
            mustLoadA = true;
        }
    }
}

