/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class MinElement {
    private MinElement() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> void compute(T alg, IndexedDataSource<U> storage, U min) {
        long size = storage.size();
        if (size <= 0L) {
            throw new IllegalArgumentException("min undefined for empty list");
        }
        Object tmp = alg.construct();
        storage.get(0L, min);
        for (long i = 1L; i < size; ++i) {
            storage.get(i, tmp);
            if (!((Ordered<U>)alg).isLess().call(tmp, min).booleanValue()) continue;
            alg.assign().call(tmp, min);
        }
    }
}

