/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.predicate.Predicate;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class Mismatch {
    private Mismatch() {
    }

    public static <T extends Algebra<T, U>, U> long compute(T algebra, IndexedDataSource<U> a, IndexedDataSource<U> b) {
        Object tmpA = algebra.construct();
        Object tmpB = algebra.construct();
        long aSize = a.size();
        for (long i = 0L; i < aSize; ++i) {
            a.get(i, tmpA);
            b.get(i, tmpB);
            if (!algebra.isNotEqual().call(tmpA, tmpB).booleanValue()) continue;
            return i;
        }
        return aSize;
    }

    public static <T extends Algebra<T, U>, U> long compute(T algebra, Predicate<Tuple2<U, U>> cond, IndexedDataSource<U> a, IndexedDataSource<U> b) {
        Object tmpA = algebra.construct();
        Object tmpB = algebra.construct();
        Tuple2 tuple = new Tuple2(tmpA, tmpB);
        long aSize = a.size();
        for (long i = 0L; i < aSize; ++i) {
            a.get(i, tmpA);
            b.get(i, tmpB);
            if (cond.isTrue(tuple)) continue;
            return i;
        }
        return aSize;
    }
}

