/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.EvenOdd;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class Multiply {
    private Multiply() {
    }

    public static <T extends Algebra<T, U> & Addition<U> & Ordered<U> & BitOperations<U>, U> void compute(T algebra, U x, U y, U z) {
        boolean yNeg;
        boolean xNeg;
        Object zero = algebra.construct();
        if (algebra.isZero().call(x).booleanValue() || algebra.isZero().call(y).booleanValue()) {
            algebra.assign().call(zero, z);
            return;
        }
        Object min = algebra.construct();
        ((Bounded)algebra).minBound().call(min);
        if (algebra.isEqual().call(x, min).booleanValue()) {
            if (((EvenOdd)algebra).isOdd().call(y).booleanValue()) {
                algebra.assign().call(min, z);
            } else {
                algebra.assign().call(zero, z);
            }
            return;
        }
        if (algebra.isEqual().call(y, min).booleanValue()) {
            if (((EvenOdd)algebra).isOdd().call(x).booleanValue()) {
                algebra.assign().call(min, z);
            } else {
                algebra.assign().call(zero, z);
            }
            return;
        }
        Object xPos = algebra.construct();
        Object yPos = algebra.construct();
        if (((Ordered<U>)algebra).isLess().call(x, zero).booleanValue()) {
            xNeg = true;
            ((Addition<U>)algebra).negate().call(x, xPos);
        } else {
            xNeg = false;
            algebra.assign().call(x, xPos);
        }
        if (((Ordered<U>)algebra).isLess().call(y, zero).booleanValue()) {
            yNeg = true;
            ((Addition<U>)algebra).negate().call(y, yPos);
        } else {
            yNeg = false;
            algebra.assign().call(y, yPos);
        }
        if (((Ordered<U>)algebra).isGreater().call(xPos, yPos).booleanValue()) {
            Object xTmp = algebra.construct();
            algebra.assign().call(xPos, xTmp);
            algebra.assign().call(yPos, xPos);
            algebra.assign().call(xTmp, yPos);
        }
        Object one = algebra.construct();
        ((Unity)algebra).unity().call(one);
        while (!((EvenOdd)algebra).isOdd().call(xPos).booleanValue()) {
            ((Addition<U>)algebra).add().call(yPos, yPos, yPos);
            ((BitOperations<U>)algebra).bitShiftRight().call(1, xPos, xPos);
        }
        if (algebra.isEqual().call(one, xPos).booleanValue()) {
            algebra.assign().call(yPos, z);
            if (xNeg != yNeg) {
                ((Addition<U>)algebra).subtract().call(zero, z, z);
            }
            return;
        }
        Object r = algebra.construct(yPos);
        Object n = algebra.construct(xPos);
        ((Addition<U>)algebra).subtract().call(n, one, n);
        ((BitOperations<U>)algebra).bitShiftRight().call(1, n, n);
        Object a = algebra.construct(yPos);
        ((Addition<U>)algebra).add().call(a, a, a);
        while (true) {
            if (((EvenOdd)algebra).isOdd().call(n).booleanValue()) {
                ((Addition<U>)algebra).add().call(r, a, r);
                if (algebra.isEqual().call(one, n).booleanValue()) {
                    algebra.assign().call(r, z);
                    if (xNeg != yNeg) {
                        ((Addition<U>)algebra).subtract().call(zero, z, z);
                    }
                    return;
                }
            }
            ((BitOperations<U>)algebra).bitShiftRight().call(1, n, n);
            ((Addition<U>)algebra).add().call(a, a, a);
        }
    }
}

