/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Median;
import nom.bdezonia.zorbage.algorithm.NonNanValues;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class NanMedian {
    private NanMedian() {
    }

    public static <T extends Algebra<T, U> & Addition<U> & Ordered<U> & NaN<U>, U extends Allocatable<U>> void compute(T alg, IndexedDataSource<U> storage, U result) {
        IndexedDataSource<U> filteredValues = NonNanValues.compute(alg, storage);
        if (filteredValues.size() == 0L) {
            ((NaN<U>)alg).nan().call(result);
        } else {
            Median.compute(alg, filteredValues, result);
        }
    }
}

