/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class NanMinElement {
    private NanMinElement() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> void compute(T alg, IndexedDataSource<U> storage, U min) {
        boolean foundSome = false;
        long size = storage.size();
        Object tmp = alg.construct();
        for (long i = 0L; i < size; ++i) {
            storage.get(i, tmp);
            if (((NaN)alg).isNaN().call(tmp).booleanValue()) continue;
            if (!foundSome) {
                alg.assign().call(tmp, min);
            }
            foundSome = true;
            if (!((Ordered<U>)alg).isLess().call(tmp, min).booleanValue()) continue;
            alg.assign().call(tmp, min);
        }
        if (!foundSome) {
            ((NaN)alg).nan().call(min);
        }
    }
}

