/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Unity;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class NanSumCount {
    private NanSumCount() {
    }

    public static <T extends Algebra<T, U> & Addition<U> & NaN<U>, U> void compute(T alg, IndexedDataSource<U> storage, U sum, U count) {
        boolean foundSome = false;
        Object tmpSum = alg.construct();
        Object tmpCnt = alg.construct();
        Object value = alg.construct();
        Object one = alg.construct();
        ((Unity)alg).unity().call(one);
        long size = storage.size();
        for (long i = 0L; i < size; ++i) {
            storage.get(i, value);
            if (((NaN<U>)alg).isNaN().call(value).booleanValue()) continue;
            foundSome = true;
            ((Addition<U>)alg).add().call(tmpSum, value, tmpSum);
            ((Addition<U>)alg).add().call(tmpCnt, one, tmpCnt);
        }
        if (foundSome) {
            alg.assign().call(tmpSum, sum);
            alg.assign().call(tmpCnt, count);
        } else {
            ((NaN<U>)alg).nan().call(sum);
            alg.zero().call(count);
        }
    }
}

