/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Derivative;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.Invertible;

public class NewtonRaphson<T extends Algebra<T, U> & Addition<U> & Infinite<U>, U>
implements Function2<Boolean, U, U> {
    private final T alg;
    private final Procedure2<U, U> f;
    private final Derivative<T, U> fPrime;
    private long maxIters;

    public NewtonRaphson(T alg, Procedure2<U, U> f, U delta, long maxIters) {
        this.alg = alg;
        this.f = f;
        this.fPrime = new Derivative<T, U>(alg, f, delta);
        this.maxIters = maxIters;
        if (maxIters <= 0L) {
            throw new IllegalArgumentException("number of iterations must be > 0");
        }
    }

    public long getMaxIters() {
        return this.maxIters;
    }

    public void setMaxIters(long maxIters) {
        this.maxIters = maxIters;
        if (maxIters <= 0L) {
            throw new IllegalArgumentException("number of iterations must be > 0");
        }
    }

    @Override
    public Boolean call(U guess, U result) {
        U tmp = this.alg.construct(guess);
        Object n = this.alg.construct();
        Object d = this.alg.construct();
        Object correction = this.alg.construct();
        for (long i = 0L; i < this.maxIters; ++i) {
            this.f.call(tmp, n);
            if (((Infinite)this.alg).isInfinite().call(n).booleanValue()) {
                return false;
            }
            this.fPrime.call(tmp, (U)d);
            if (this.alg.isZero().call(d).booleanValue()) {
                return false;
            }
            ((Invertible)this.alg).divide().call(n, d, correction);
            ((Addition)this.alg).subtract().call(tmp, correction, tmp);
        }
        this.alg.assign().call(tmp, result);
        return true;
    }
}

