/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class NonNanValues {
    private NonNanValues() {
    }

    public static <T extends Algebra<T, U> & NaN<U>, U extends Allocatable<U>> IndexedDataSource<U> compute(T alg, IndexedDataSource<U> storage) {
        Allocatable value = (Allocatable)alg.construct();
        long valueCount = 0L;
        long sz = storage.size();
        for (long i = 0L; i < sz; ++i) {
            storage.get(i, value);
            if (((NaN<U>)alg).isNaN().call(value).booleanValue()) continue;
            ++valueCount;
        }
        IndexedDataSource<Allocatable> filteredValues = Storage.allocate(valueCount, value);
        valueCount = 0L;
        for (long i = 0L; i < sz; ++i) {
            storage.get(i, value);
            if (((NaN<U>)alg).isNaN().call(value).booleanValue()) continue;
            filteredValues.set(valueCount, value);
            ++valueCount;
        }
        return filteredValues;
    }
}

