/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;

public class NumberWithin {
    private NumberWithin() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> boolean compute(T algebra, U tolerance, U a, U b) {
        Object zero = algebra.construct();
        Object diff = algebra.construct();
        U tol = algebra.construct(tolerance);
        if (((Ordered<U>)algebra).isLess().call(tol, zero).booleanValue()) {
            throw new IllegalArgumentException("tolerance must be >= 0");
        }
        int sigA = ((Ordered<U>)algebra).signum().call(a);
        int sigB = ((Ordered<U>)algebra).signum().call(b);
        if (sigA < 0) {
            if (sigB < 0) {
                if (((Ordered<U>)algebra).isGreater().call(a, b).booleanValue()) {
                    ((Addition)algebra).subtract().call(b, a, diff);
                } else {
                    ((Addition)algebra).subtract().call(a, b, diff);
                }
                if (((Ordered<U>)algebra).isLess().call(diff, zero).booleanValue()) {
                    ((Addition)algebra).negate().call(diff, diff);
                }
                return ((Ordered<U>)algebra).isGreater().call(diff, tol) == false;
            }
            if (sigB > 0) {
                if (((Ordered<U>)algebra).isGreater().call(b, tol).booleanValue()) {
                    return false;
                }
                ((Addition)algebra).negate().call(tol, tol);
                if (((Ordered<U>)algebra).isLess().call(a, tol).booleanValue()) {
                    return false;
                }
                ((Addition)algebra).add().call(b, tol, diff);
                return ((Ordered<U>)algebra).isGreater().call(diff, a) == false;
            }
            ((Addition)algebra).negate().call(tol, tol);
            return ((Ordered<U>)algebra).isLess().call(a, tol) == false;
        }
        if (sigA > 0) {
            if (sigB < 0) {
                if (((Ordered<U>)algebra).isGreater().call(a, tol).booleanValue()) {
                    return false;
                }
                ((Addition)algebra).negate().call(tol, tol);
                if (((Ordered<U>)algebra).isLess().call(b, tol).booleanValue()) {
                    return false;
                }
                ((Addition)algebra).add().call(a, tol, diff);
                return ((Ordered<U>)algebra).isGreater().call(diff, b) == false;
            }
            if (sigB > 0) {
                if (((Ordered<U>)algebra).isLess().call(a, b).booleanValue()) {
                    ((Addition)algebra).subtract().call(b, a, diff);
                } else {
                    ((Addition)algebra).subtract().call(a, b, diff);
                }
                return ((Ordered<U>)algebra).isGreater().call(diff, tol) == false;
            }
            return ((Ordered<U>)algebra).isGreater().call(a, tol) == false;
        }
        if (sigB < 0) {
            ((Addition)algebra).negate().call(tol, tol);
            return ((Ordered<U>)algebra).isLess().call(b, tol) == false;
        }
        if (sigB > 0) {
            return ((Ordered<U>)algebra).isGreater().call(b, tol) == false;
        }
        return true;
    }
}

