/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import java.math.BigDecimal;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class OdeSolveRK4 {
    public static <T extends Algebra<T, U> & Addition<U>, U, V extends Algebra<V, W> & Addition<W>, W> void compute(T uAlg, V wAlg, Procedure3<W, U, U> proc, W t0, U y0, long numSteps, W dt, IndexedDataSource<U> results) {
        if (numSteps <= 0L) {
            throw new IllegalArgumentException("numSteps must be greater than 0");
        }
        if (wAlg.isZero().call(dt).booleanValue()) {
            throw new IllegalArgumentException("time increment dt must not be 0");
        }
        if (results.size() != numSteps) {
            throw new IllegalArgumentException("output array size does not match numSteps");
        }
        W t = wAlg.construct(t0);
        U y = uAlg.construct(y0);
        Object k1 = uAlg.construct();
        Object k2 = uAlg.construct();
        Object k3 = uAlg.construct();
        Object k4 = uAlg.construct();
        Object dy = uAlg.construct();
        String one_half = wAlg.construct((String)"0.5");
        String one_sixth = wAlg.construct((String)BigDecimal.ONE.divide(BigDecimal.valueOf(6L), HighPrecisionAlgebra.getContext()).toString());
        Object tmp = uAlg.construct();
        Object tt = wAlg.construct();
        Object ty = uAlg.construct();
        Object dt_over_two = wAlg.construct();
        ((Scale)wAlg).scale().call(one_half, dt, dt_over_two);
        results.set(0L, y);
        int i = 1;
        while ((long)i < numSteps) {
            proc.call(t, y, tmp);
            ((Scale)uAlg).scale().call(dt, tmp, k1);
            ((Addition<W>)wAlg).add().call(t, dt_over_two, tt);
            ((Scale)uAlg).scale().call(one_half, k1, ty);
            ((Addition<U>)uAlg).add().call(y, ty, ty);
            proc.call(tt, ty, tmp);
            ((Scale)uAlg).scale().call(dt, tmp, k2);
            ((Scale)uAlg).scale().call(one_half, k2, ty);
            ((Addition<U>)uAlg).add().call(y, ty, ty);
            proc.call(tt, ty, tmp);
            ((Scale)uAlg).scale().call(dt, tmp, k3);
            ((Addition<W>)wAlg).add().call(t, dt, tt);
            ((Addition<U>)uAlg).add().call(y, k3, ty);
            proc.call(tt, ty, tmp);
            ((Scale)uAlg).scale().call(dt, tmp, k4);
            ((Addition<U>)uAlg).add().call(k1, k2, dy);
            ((Addition<U>)uAlg).add().call(dy, k2, dy);
            ((Addition<U>)uAlg).add().call(dy, k3, dy);
            ((Addition<U>)uAlg).add().call(dy, k3, dy);
            ((Addition<U>)uAlg).add().call(dy, k4, dy);
            ((Scale)uAlg).scale().call(one_sixth, dy, dy);
            ((Addition<U>)uAlg).add().call(y, dy, y);
            ((Addition<W>)wAlg).add().call(t, dt, t);
            results.set(i, y);
            ++i;
        }
    }
}

