/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.Multiplication;

public class ParallelMatrixMultiply {
    private ParallelMatrixMultiply() {
    }

    public static <T extends Algebra<T, U> & Addition<U>, U> void compute(T algebra, MatrixMember<U> a, MatrixMember<U> b, MatrixMember<U> c) {
        if (c == a || c == b) {
            throw new IllegalArgumentException("dangerous matrix multiply definition");
        }
        if (a.cols() != b.rows()) {
            throw new IllegalArgumentException("incompatible matrix shapes in matrix multiply");
        }
        long rows = a.rows();
        long cols = b.cols();
        c.alloc(rows, cols);
        long numRows = rows;
        long pieces = Runtime.getRuntime().availableProcessors();
        if (pieces > numRows) {
            pieces = numRows;
        }
        if (pieces > Integer.MAX_VALUE) {
            pieces = Integer.MAX_VALUE;
        }
        Thread[] threads = new Thread[(int)pieces];
        long start = 0L;
        int i = 0;
        while ((long)i < pieces) {
            long end = (long)i == pieces - 1L ? numRows : start + numRows / pieces;
            Computer<T, U> computer = new Computer<T, U>(algebra, start, end, a, b, c);
            threads[i] = new Thread(computer);
            start = end;
            ++i;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread execution error in ParallelMatrixMultiply");
            }
        }
    }

    private static class Computer<T extends Algebra<T, U> & Addition<U>, U>
    implements Runnable {
        private final T algebra;
        private final long start;
        private final long end;
        private final MatrixMember<U> a;
        private final MatrixMember<U> b;
        private final MatrixMember<U> c;

        public Computer(T algebra, long start, long end, MatrixMember<U> a, MatrixMember<U> b, MatrixMember<U> c) {
            this.algebra = algebra;
            this.start = start;
            this.end = end;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        @Override
        public void run() {
            Object sum = this.algebra.construct();
            Object atmp = this.algebra.construct();
            Object btmp = this.algebra.construct();
            Object term = this.algebra.construct();
            long cols = this.b.cols();
            long common = this.a.cols();
            for (long row = this.start; row < this.end; ++row) {
                for (long col = 0L; col < cols; ++col) {
                    this.algebra.zero().call(sum);
                    for (long i = 0L; i < common; ++i) {
                        this.a.v(row, i, atmp);
                        this.b.v(i, col, btmp);
                        ((Multiplication)this.algebra).multiply().call(atmp, btmp, term);
                        ((Addition)this.algebra).add().call(sum, term, sum);
                    }
                    this.c.setV(row, col, sum);
                }
            }
        }
    }
}

