/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Transform1;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.TrimmedDataSource;

public class ParallelTransform1 {
    private ParallelTransform1() {
    }

    public static <T extends Algebra<T, U>, U> void compute(T algU, Procedure1<U> proc, IndexedDataSource<U> a) {
        int i;
        int numProcs;
        long aSize = a.size();
        if (aSize < (long)(numProcs = Runtime.getRuntime().availableProcessors())) {
            numProcs = (int)aSize;
        }
        Thread[] threads = new Thread[numProcs];
        long thOffset = 0L;
        long slice = aSize / (long)numProcs;
        for (i = 0; i < numProcs; ++i) {
            long thSize = i != numProcs - 1 ? slice : aSize;
            TrimmedDataSource<U> aTrimmed = new TrimmedDataSource<U>(a, thOffset, thSize);
            Computer<T, U> r = new Computer<T, U>(algU, proc, aTrimmed);
            threads[i] = new Thread(r);
            thOffset += slice;
            aSize -= slice;
        }
        for (i = 0; i < numProcs; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numProcs; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread execution error in ParallelTransform");
            }
        }
    }

    private static class Computer<T extends Algebra<T, U>, U>
    implements Runnable {
        private final T algebraU;
        private final IndexedDataSource<U> list1;
        private final Procedure1<U> proc;

        Computer(T algU, Procedure1<U> proc, IndexedDataSource<U> a) {
            this.algebraU = algU;
            this.list1 = a;
            this.proc = proc;
        }

        @Override
        public void run() {
            Transform1.compute(this.algebraU, this.proc, this.list1);
        }
    }
}

