/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.TrimmedDataSource;

public class ParallelTransform2 {
    private ParallelTransform2() {
    }

    public static <T extends Algebra<T, U>, U> void compute(T algU, Procedure2<U, U> proc, IndexedDataSource<U> a, IndexedDataSource<U> b) {
        ParallelTransform2.compute(algU, algU, proc, a, b);
    }

    public static <T extends Algebra<T, U>, U, V extends Algebra<V, W>, W> void compute(T algU, V algW, Procedure2<U, W> proc, IndexedDataSource<U> a, IndexedDataSource<W> b) {
        int i;
        int numProcs;
        long aSize = a.size();
        if (aSize < (long)(numProcs = Runtime.getRuntime().availableProcessors())) {
            numProcs = (int)aSize;
        }
        Thread[] threads = new Thread[numProcs];
        long thOffset = 0L;
        long slice = aSize / (long)numProcs;
        for (i = 0; i < numProcs; ++i) {
            long thSize = i != numProcs - 1 ? slice : aSize;
            TrimmedDataSource<U> aTrimmed = new TrimmedDataSource<U>(a, thOffset, thSize);
            TrimmedDataSource<W> bTrimmed = new TrimmedDataSource<W>(b, thOffset, thSize);
            Computer<T, U, V, W> r = new Computer<T, U, V, W>(algU, algW, proc, aTrimmed, bTrimmed);
            threads[i] = new Thread(r);
            thOffset += slice;
            aSize -= slice;
        }
        for (i = 0; i < numProcs; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numProcs; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread execution error in ParallelTransform");
            }
        }
    }

    private static class Computer<T extends Algebra<T, U>, U, V extends Algebra<V, W>, W>
    implements Runnable {
        private final T algebraU;
        private final V algebraW;
        private final IndexedDataSource<U> list1;
        private final IndexedDataSource<W> list2;
        private final Procedure2<U, W> proc;

        Computer(T algU, V algW, Procedure2<U, W> proc, IndexedDataSource<U> a, IndexedDataSource<W> b) {
            this.algebraU = algU;
            this.algebraW = algW;
            this.list1 = a;
            this.list2 = b;
            this.proc = proc;
        }

        @Override
        public void run() {
            Transform2.compute(this.algebraU, this.algebraW, this.proc, this.list1, this.list2);
        }
    }
}

