/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.TrimmedDataSource;

public class ParallelTransform3 {
    private ParallelTransform3() {
    }

    public static <T extends Algebra<T, U>, U> void compute(T algU, Procedure3<U, U, U> proc, IndexedDataSource<U> a, IndexedDataSource<U> b, IndexedDataSource<U> c) {
        ParallelTransform3.compute(algU, algU, algU, proc, a, b, c);
    }

    public static <T extends Algebra<T, U>, U, V extends Algebra<V, W>, W, X extends Algebra<X, Y>, Y> void compute(T algU, V algW, X algX, Procedure3<U, W, Y> proc, IndexedDataSource<U> a, IndexedDataSource<W> b, IndexedDataSource<Y> c) {
        int i;
        int numProcs;
        long aSize = a.size();
        if (aSize < (long)(numProcs = Runtime.getRuntime().availableProcessors())) {
            numProcs = (int)aSize;
        }
        Thread[] threads = new Thread[numProcs];
        long thOffset = 0L;
        long slice = aSize / (long)numProcs;
        for (i = 0; i < numProcs; ++i) {
            long thSize = i != numProcs - 1 ? slice : aSize;
            TrimmedDataSource<U> aTrimmed = new TrimmedDataSource<U>(a, thOffset, thSize);
            TrimmedDataSource<W> bTrimmed = new TrimmedDataSource<W>(b, thOffset, thSize);
            TrimmedDataSource<Y> cTrimmed = new TrimmedDataSource<Y>(c, thOffset, thSize);
            Computer<T, U, V, W, X, Y> r = new Computer<T, U, V, W, X, Y>(algU, algW, algX, proc, aTrimmed, bTrimmed, cTrimmed);
            threads[i] = new Thread(r);
            thOffset += slice;
            aSize -= slice;
        }
        for (i = 0; i < numProcs; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numProcs; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread execution error in ParallelTransform");
            }
        }
    }

    private static class Computer<T extends Algebra<T, U>, U, V extends Algebra<V, W>, W, X extends Algebra<X, Y>, Y>
    implements Runnable {
        private final T algebraU;
        private final V algebraW;
        private final X algebraY;
        private final IndexedDataSource<U> list1;
        private final IndexedDataSource<W> list2;
        private final IndexedDataSource<Y> list3;
        private final Procedure3<U, W, Y> proc;

        Computer(T algU, V algW, X algY, Procedure3<U, W, Y> proc, IndexedDataSource<U> a, IndexedDataSource<W> b, IndexedDataSource<Y> c) {
            this.algebraU = algU;
            this.algebraW = algW;
            this.algebraY = algY;
            this.list1 = a;
            this.list2 = b;
            this.list3 = c;
            this.proc = proc;
        }

        @Override
        public void run() {
            Transform3.compute(this.algebraU, this.algebraW, this.algebraY, this.proc, this.list1, this.list2, this.list3);
        }
    }
}

