/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Transform4;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.TrimmedDataSource;

public class ParallelTransform4 {
    private ParallelTransform4() {
    }

    public static <T extends Algebra<T, U>, U> void compute(T algU, Procedure4<U, U, U, U> proc, IndexedDataSource<U> a, IndexedDataSource<U> b, IndexedDataSource<U> c, IndexedDataSource<U> d) {
        ParallelTransform4.compute(algU, algU, algU, algU, proc, a, b, c, d);
    }

    public static <T extends Algebra<T, U>, U, V extends Algebra<V, W>, W, X extends Algebra<X, Y>, Y, Z extends Algebra<Z, A>, A> void compute(T algU, V algW, X algX, Z algZ, Procedure4<U, W, Y, A> proc, IndexedDataSource<U> a, IndexedDataSource<W> b, IndexedDataSource<Y> c, IndexedDataSource<A> d) {
        int i;
        int numProcs;
        long aSize = a.size();
        if (aSize < (long)(numProcs = Runtime.getRuntime().availableProcessors())) {
            numProcs = (int)aSize;
        }
        Thread[] threads = new Thread[numProcs];
        long thOffset = 0L;
        long slice = aSize / (long)numProcs;
        for (i = 0; i < numProcs; ++i) {
            long thSize = i != numProcs - 1 ? slice : aSize;
            TrimmedDataSource<U> aTrimmed = new TrimmedDataSource<U>(a, thOffset, thSize);
            TrimmedDataSource<W> bTrimmed = new TrimmedDataSource<W>(b, thOffset, thSize);
            TrimmedDataSource<Y> cTrimmed = new TrimmedDataSource<Y>(c, thOffset, thSize);
            TrimmedDataSource<A> dTrimmed = new TrimmedDataSource<A>(d, thOffset, thSize);
            Computer<T, U, V, W, X, Y, Z, A> r = new Computer<T, U, V, W, X, Y, Z, A>(algU, algW, algX, algZ, proc, aTrimmed, bTrimmed, cTrimmed, dTrimmed);
            threads[i] = new Thread(r);
            thOffset += slice;
            aSize -= slice;
        }
        for (i = 0; i < numProcs; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numProcs; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread execution error in ParallelTransform");
            }
        }
    }

    private static class Computer<T extends Algebra<T, U>, U, V extends Algebra<V, W>, W, X extends Algebra<X, Y>, Y, Z extends Algebra<Z, A>, A>
    implements Runnable {
        private final T algebraU;
        private final V algebraW;
        private final X algebraY;
        private final Z algebraA;
        private final IndexedDataSource<U> list1;
        private final IndexedDataSource<W> list2;
        private final IndexedDataSource<Y> list3;
        private final IndexedDataSource<A> list4;
        private final Procedure4<U, W, Y, A> proc;

        Computer(T algU, V algW, X algY, Z algA, Procedure4<U, W, Y, A> proc, IndexedDataSource<U> a, IndexedDataSource<W> b, IndexedDataSource<Y> c, IndexedDataSource<A> d) {
            this.algebraU = algU;
            this.algebraW = algW;
            this.algebraY = algY;
            this.algebraA = algA;
            this.list1 = a;
            this.list2 = b;
            this.list3 = c;
            this.list4 = d;
            this.proc = proc;
        }

        @Override
        public void run() {
            Transform4.compute(this.algebraU, this.algebraW, this.algebraY, this.algebraA, this.proc, this.list1, this.list2, this.list3, this.list4);
        }
    }
}

