/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.predicate.Predicate;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class PartitionPoint {
    private PartitionPoint() {
    }

    public static <T extends Algebra<T, U>, U> long compute(T alg, Predicate<U> cond, IndexedDataSource<U> storage) {
        Object value = alg.construct();
        long n = storage.size();
        long first = 0L;
        while (n > 0L) {
            long it = first;
            long step = n / 2L;
            storage.get(it += step, value);
            if (cond.isTrue(value)) {
                first = it + 1L;
                n -= step + 1L;
                continue;
            }
            n = step;
        }
        return first;
    }
}

