/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.RModule;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.algebra.Ring;

public class PerpDotProduct {
    private PerpDotProduct() {
    }

    public static <T extends RModule<T, U, V, W>, U extends RModuleMember<W>, V extends Ring<V, W>, W> void compute(T rmodAlgebra, V memberAlgebra, U a, U b, W c) {
        if (a.length() != 2L || b.length() != 2L) {
            throw new UnsupportedOperationException("perp dot product only defined for 2 dimensions");
        }
        Object atmp = memberAlgebra.construct();
        Object btmp = memberAlgebra.construct();
        Object term1 = memberAlgebra.construct();
        Object term2 = memberAlgebra.construct();
        a.v(1L, atmp);
        b.v(0L, btmp);
        memberAlgebra.negate().call(atmp, atmp);
        memberAlgebra.multiply().call(atmp, btmp, term1);
        a.v(0L, atmp);
        b.v(1L, btmp);
        memberAlgebra.multiply().call(atmp, btmp, term2);
        memberAlgebra.add().call(term1, term2, c);
    }
}

