/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.point.Point;

public class PointDistance {
    private PointDistance() {
    }

    public static void compute(Point a, Point b, Float64Member result) {
        if (a.numDimensions() != b.numDimensions()) {
            throw new IllegalArgumentException("points do not share the same dimensionality");
        }
        double max = 0.0;
        for (int i = 0; i < a.numDimensions(); ++i) {
            double term = Math.abs(a.component(i) - b.component(i));
            max = Math.max(term, max);
        }
        if (max == 0.0) {
            result.setV(0.0);
            return;
        }
        double sum = 0.0;
        for (int i = 0; i < a.numDimensions(); ++i) {
            double term = (a.component(i) - b.component(i)) / max;
            sum += term * term;
        }
        result.setV(max * Math.sqrt(sum));
    }
}

