/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class PowerNonNegative {
    private PowerNonNegative() {
    }

    public static <T extends Algebra<T, U> & Multiplication<U>, U> void compute(T algebra, int power, U a, U b) {
        if (power < 0) {
            throw new IllegalArgumentException("Cannot get negative powers from integers");
        }
        if (power == 0 && algebra.isZero().call(a).booleanValue()) {
            throw new IllegalArgumentException("0^0 is not a number");
        }
        PowerNonNegative.pow(algebra, power, a, b);
    }

    private static <T extends Algebra<T, U> & Multiplication<U>, U> void pow(T algebra, int pow, U a, U b) {
        if (pow == 0) {
            ((Unity)algebra).unity().call(b);
        } else if (pow == 1) {
            algebra.assign().call(a, b);
        } else {
            Object tmp = algebra.construct();
            int halfPow = pow >>> 1;
            PowerNonNegative.pow(algebra, halfPow, a, tmp);
            ((Multiplication<U>)algebra).multiply().call(tmp, tmp, tmp);
            if (pow != halfPow << 1) {
                ((Multiplication<U>)algebra).multiply().call(tmp, a, tmp);
            }
            algebra.assign().call(tmp, b);
        }
    }
}

