/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Reverse;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.TrimmedDataSource;

public class PrevPermutation {
    private PrevPermutation() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> boolean compute(T alg, IndexedDataSource<U> a) {
        long first = 0L;
        long last = a.size();
        if (first == last) {
            return false;
        }
        long i = first;
        if (++i == last) {
            return false;
        }
        i = last;
        --i;
        Object tmp1 = alg.construct();
        Object tmp2 = alg.construct();
        do {
            long ii = i--;
            a.get(ii, tmp1);
            a.get(i, tmp2);
            if (!((Ordered<U>)alg).isLess().call(tmp1, tmp2).booleanValue()) continue;
            long j = last;
            a.get(--j, tmp1);
            while (((Ordered<U>)alg).isGreaterEqual().call(tmp1, tmp2).booleanValue()) {
                a.get(--j, tmp1);
            }
            a.get(i, tmp1);
            a.get(j, tmp2);
            a.set(i, tmp2);
            a.set(j, tmp1);
            TrimmedDataSource<U> tmpList = new TrimmedDataSource<U>(a, ii, last - ii);
            Reverse.compute(alg, tmpList);
            return true;
        } while (i != first);
        TrimmedDataSource<U> tmpList = new TrimmedDataSource<U>(a, first, last - first);
        Reverse.compute(alg, tmpList);
        return false;
    }
}

