/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Unity;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class RampFill {
    private RampFill() {
    }

    public static <T extends Algebra<T, U> & Addition<U>, U> void compute(T alg, U startVal, U incBy, IndexedDataSource<U> data) {
        if (alg.isZero().call(incBy).booleanValue()) {
            throw new IllegalArgumentException("FillRamp expects nonzero increment");
        }
        U tmp = alg.construct(startVal);
        long sz = data.size();
        for (long i = 0L; i < sz; ++i) {
            data.set(i, tmp);
            ((Addition<U>)alg).add().call(tmp, incBy, tmp);
        }
    }

    public static <T extends Algebra<T, U> & Addition<U>, U> void compute(T alg, IndexedDataSource<U> data) {
        Object zero = alg.construct();
        Object one = alg.construct();
        ((Unity)alg).unity().call(one);
        RampFill.compute(alg, zero, one, data);
    }
}

