/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class RotateCopy {
    private RotateCopy() {
    }

    public static <T extends Algebra<T, U>, U> void compute(T algebra, long delta, IndexedDataSource<U> a, IndexedDataSource<U> b) {
        if (a == b) {
            throw new IllegalArgumentException("RotateCopy does not work in place");
        }
        long sz = a.size();
        if (sz == 0L) {
            return;
        }
        if (delta == 0L) {
            return;
        }
        if (Math.abs(delta) >= sz) {
            throw new IllegalArgumentException("delta magnitude too large");
        }
        Object tmp1 = algebra.construct();
        long index = 0L;
        for (long i = 0L; i < sz; ++i) {
            index = i - delta;
            if (index < 0L) {
                index += sz;
            }
            if (index >= sz) {
                index -= sz;
            }
            a.get(i, tmp1);
            b.set(index, tmp1);
        }
    }
}

