/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.AbsoluteValue;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.ModularDivision;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class Round {
    private Round() {
    }

    public static <T extends Algebra<T, U> & Addition<U> & Unity<U> & Ordered<U>, U> void compute(T algebra, Mode mode, U delta, U a, U b) {
        if (mode == Mode.NONE) {
            algebra.assign().call(a, b);
            return;
        }
        Object zero = algebra.construct();
        if (((Ordered<U>)algebra).isLessEqual().call(delta, zero).booleanValue()) {
            throw new IllegalArgumentException("rounding error: delta must be > 0");
        }
        Object d = algebra.construct();
        Object m = algebra.construct();
        Object absM = algebra.construct();
        Object bTmp = algebra.construct();
        Object d1 = algebra.construct();
        Object m1 = algebra.construct();
        Object two = algebra.construct();
        ((Unity<U>)algebra).unity().call(two);
        ((Addition<U>)algebra).add().call(two, two, two);
        ((ModularDivision)algebra).divMod().call(a, delta, d, m);
        ((Multiplication)algebra).multiply().call(delta, d, bTmp);
        if (algebra.isNotEqual().call(m, zero).booleanValue()) {
            switch (mode) {
                case NEGATIVE: {
                    if (algebra.isEqual().call(bTmp, zero).booleanValue()) {
                        if (!((Ordered<U>)algebra).isLess().call(m, zero).booleanValue()) break;
                        ((Addition<U>)algebra).subtract().call(bTmp, delta, bTmp);
                        break;
                    }
                    if (!((Ordered<U>)algebra).isLess().call(bTmp, zero).booleanValue()) break;
                    ((Addition<U>)algebra).subtract().call(bTmp, delta, bTmp);
                    break;
                }
                case POSITIVE: {
                    if (algebra.isEqual().call(bTmp, zero).booleanValue()) {
                        if (!((Ordered<U>)algebra).isGreater().call(m, zero).booleanValue()) break;
                        ((Addition<U>)algebra).add().call(bTmp, delta, bTmp);
                        break;
                    }
                    if (!((Ordered<U>)algebra).isGreater().call(bTmp, zero).booleanValue()) break;
                    ((Addition<U>)algebra).add().call(bTmp, delta, bTmp);
                    break;
                }
                case TOWARDS_ORIGIN: {
                    break;
                }
                case AWAY_FROM_ORIGIN: {
                    if (algebra.isEqual().call(bTmp, zero).booleanValue()) {
                        if (((Ordered<U>)algebra).isGreater().call(m, zero).booleanValue()) {
                            ((Addition<U>)algebra).add().call(bTmp, delta, bTmp);
                            break;
                        }
                        ((Addition<U>)algebra).subtract().call(bTmp, delta, bTmp);
                        break;
                    }
                    if (((Ordered<U>)algebra).isGreater().call(bTmp, zero).booleanValue()) {
                        ((Addition<U>)algebra).add().call(bTmp, delta, bTmp);
                        break;
                    }
                    ((Addition<U>)algebra).subtract().call(bTmp, delta, bTmp);
                    break;
                }
                case HALF_UP: {
                    ((AbsoluteValue)algebra).abs().call(m, absM);
                    ((Addition<U>)algebra).subtract().call(delta, absM, d1);
                    if (((Ordered<U>)algebra).isGreater().call(bTmp, zero).booleanValue() || algebra.isEqual().call(bTmp, zero).booleanValue() && ((Ordered<U>)algebra).isGreater().call(m, zero).booleanValue()) {
                        if (!((Ordered<U>)algebra).isGreaterEqual().call(absM, d1).booleanValue()) break;
                        ((Addition<U>)algebra).add().call(bTmp, delta, bTmp);
                        break;
                    }
                    if (!((Ordered<U>)algebra).isLess().call(bTmp, zero).booleanValue() && (!algebra.isEqual().call(bTmp, zero).booleanValue() || !((Ordered<U>)algebra).isLess().call(m, zero).booleanValue()) || !((Ordered<U>)algebra).isGreaterEqual().call(absM, d1).booleanValue()) break;
                    ((Addition<U>)algebra).subtract().call(bTmp, delta, bTmp);
                    break;
                }
                case HALF_DOWN: {
                    ((AbsoluteValue)algebra).abs().call(m, absM);
                    ((Addition<U>)algebra).subtract().call(delta, absM, d1);
                    if (((Ordered<U>)algebra).isGreater().call(bTmp, zero).booleanValue() || algebra.isEqual().call(bTmp, zero).booleanValue() && ((Ordered<U>)algebra).isGreater().call(m, zero).booleanValue()) {
                        if (!((Ordered<U>)algebra).isGreater().call(absM, d1).booleanValue()) break;
                        ((Addition<U>)algebra).add().call(bTmp, delta, bTmp);
                        break;
                    }
                    if (!((Ordered<U>)algebra).isLess().call(bTmp, zero).booleanValue() && (!algebra.isEqual().call(bTmp, zero).booleanValue() || !((Ordered<U>)algebra).isLess().call(m, zero).booleanValue()) || !((Ordered<U>)algebra).isGreater().call(absM, d1).booleanValue()) break;
                    ((Addition<U>)algebra).subtract().call(bTmp, delta, bTmp);
                    break;
                }
                case HALF_EVEN: {
                    ((AbsoluteValue)algebra).abs().call(m, absM);
                    ((Addition<U>)algebra).subtract().call(delta, absM, d1);
                    if (((Ordered<U>)algebra).isGreater().call(bTmp, zero).booleanValue() || algebra.isEqual().call(bTmp, zero).booleanValue() && ((Ordered<U>)algebra).isGreater().call(m, zero).booleanValue()) {
                        if (((Ordered<U>)algebra).isGreater().call(absM, d1).booleanValue()) {
                            ((Addition<U>)algebra).add().call(bTmp, delta, bTmp);
                            break;
                        }
                        if (!algebra.isEqual().call(absM, d1).booleanValue()) break;
                        ((ModularDivision)algebra).mod().call(d, two, m1);
                        if (!algebra.isNotEqual().call(m1, zero).booleanValue()) break;
                        ((Addition<U>)algebra).add().call(bTmp, delta, bTmp);
                        break;
                    }
                    if (!((Ordered<U>)algebra).isLess().call(bTmp, zero).booleanValue() && (!algebra.isEqual().call(bTmp, zero).booleanValue() || !((Ordered<U>)algebra).isLess().call(m, zero).booleanValue())) break;
                    if (((Ordered<U>)algebra).isGreater().call(absM, d1).booleanValue()) {
                        ((Addition<U>)algebra).subtract().call(bTmp, delta, bTmp);
                        break;
                    }
                    if (!algebra.isEqual().call(absM, d1).booleanValue()) break;
                    ((ModularDivision)algebra).mod().call(d, two, m1);
                    if (!algebra.isNotEqual().call(m1, zero).booleanValue()) break;
                    ((Addition<U>)algebra).subtract().call(bTmp, delta, bTmp);
                    break;
                }
                case HALF_ODD: {
                    ((AbsoluteValue)algebra).abs().call(m, absM);
                    ((Addition<U>)algebra).subtract().call(delta, absM, d1);
                    if (((Ordered<U>)algebra).isGreater().call(bTmp, zero).booleanValue() || algebra.isEqual().call(bTmp, zero).booleanValue() && ((Ordered<U>)algebra).isGreater().call(m, zero).booleanValue()) {
                        if (((Ordered<U>)algebra).isGreater().call(absM, d1).booleanValue()) {
                            ((Addition<U>)algebra).add().call(bTmp, delta, bTmp);
                            break;
                        }
                        if (!algebra.isEqual().call(absM, d1).booleanValue()) break;
                        ((ModularDivision)algebra).mod().call(d, two, m1);
                        if (!algebra.isEqual().call(m1, zero).booleanValue()) break;
                        ((Addition<U>)algebra).add().call(bTmp, delta, bTmp);
                        break;
                    }
                    if (!((Ordered<U>)algebra).isLess().call(bTmp, zero).booleanValue() && (!algebra.isEqual().call(bTmp, zero).booleanValue() || !((Ordered<U>)algebra).isLess().call(m, zero).booleanValue())) break;
                    if (((Ordered<U>)algebra).isGreater().call(absM, d1).booleanValue()) {
                        ((Addition<U>)algebra).subtract().call(bTmp, delta, bTmp);
                        break;
                    }
                    if (!algebra.isEqual().call(absM, d1).booleanValue()) break;
                    ((ModularDivision)algebra).mod().call(d, two, m1);
                    if (!algebra.isEqual().call(m1, zero).booleanValue()) break;
                    ((Addition<U>)algebra).subtract().call(bTmp, delta, bTmp);
                    break;
                }
                case EXACT: {
                    throw new ArithmeticException("exact rounding check failed");
                }
                default: {
                    if (mode == Mode.NONE) break;
                    throw new IllegalArgumentException("Unknown rounding mode: " + (Object)((Object)mode));
                }
            }
        }
        algebra.assign().call(bTmp, b);
    }

    public static enum Mode {
        NONE,
        NEGATIVE,
        POSITIVE,
        TOWARDS_ORIGIN,
        AWAY_FROM_ORIGIN,
        HALF_UP,
        HALF_DOWN,
        HALF_EVEN,
        HALF_ODD,
        EXACT;

    }
}

