/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;

public class ScientificNotation {
    private static final MathContext context = new MathContext(100, RoundingMode.HALF_EVEN);

    private ScientificNotation() {
    }

    public static <U extends UniversalRepresentation> void compute(BigDecimal fraction, int base, int power, U result) {
        BigDecimal b = BigDecimal.valueOf(base);
        BigDecimal tmp = b.pow(power, context);
        BigDecimal value = tmp.multiply(fraction, context);
        OctonionRepresentation v = new OctonionRepresentation();
        v.setR(value);
        TensorOctonionRepresentation rep = new TensorOctonionRepresentation();
        rep.setValue(v);
        result.fromRep(rep);
    }
}

