/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class SequenceIsInf {
    private SequenceIsInf() {
    }

    public static <T extends Algebra<T, U> & Infinite<U>, U> boolean compute(T algebra, IndexedDataSource<U> a) {
        boolean infFound = false;
        Object value = algebra.construct();
        long size = a.size();
        for (long i = 0L; i < size; ++i) {
            a.get(i, value);
            if (((NaN)algebra).isNaN().call(value).booleanValue()) {
                return false;
            }
            if (infFound || !((Infinite<U>)algebra).isInfinite().call(value).booleanValue()) continue;
            infFound = true;
        }
        return infFound;
    }
}

