/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Find;
import nom.bdezonia.zorbage.algorithm.Sort;
import nom.bdezonia.zorbage.algorithm.Unique;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class SetIntersection {
    private SetIntersection() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U extends Allocatable<U>> IndexedDataSource<U> compute(T alg, IndexedDataSource<U> a, IndexedDataSource<U> b) {
        Allocatable type = (Allocatable)alg.construct();
        long aSize = a.size();
        long bSize = b.size();
        IndexedDataSource<Allocatable> tmpList = Storage.allocate(aSize, type);
        long count = 0L;
        Allocatable value = (Allocatable)alg.construct();
        for (long ai = 0L; ai < aSize; ++ai) {
            a.get(ai, value);
            if (Find.compute(alg, value, b) >= bSize) continue;
            tmpList.set(count++, value);
        }
        if (count == 0L) {
            return Storage.allocate(0L, type);
        }
        tmpList.get(0L, value);
        for (long i = count; i < aSize; ++i) {
            tmpList.set(i, value);
        }
        Sort.compute(alg, tmpList);
        return Unique.compute(alg, tmpList);
    }
}

