/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class Sort {
    private Sort() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> void compute(T alg, IndexedDataSource<U> storage) {
        Sort.qsort(alg, ((Ordered<U>)alg).isLess(), storage, 0L, storage.size() - 1L);
    }

    public static <T extends Algebra<T, U>, U> void compute(T alg, Function2<Boolean, U, U> isLeftOf, IndexedDataSource<U> storage) {
        Sort.qsort(alg, isLeftOf, storage, 0L, storage.size() - 1L);
    }

    private static <T extends Algebra<T, U>, U> void qsort(T alg, Function2<Boolean, U, U> isLeftOf, IndexedDataSource<U> storage, long left, long right) {
        if (left < right) {
            if (right - left < 10L) {
                Sort.insertionSort(alg, isLeftOf, storage, left, right);
            } else {
                long pivotPoint = Sort.partition(alg, isLeftOf, storage, left, right);
                Sort.qsort(alg, isLeftOf, storage, left, pivotPoint - 1L);
                Sort.qsort(alg, isLeftOf, storage, pivotPoint + 1L, right);
            }
        }
    }

    private static <T extends Algebra<T, U>, U> long partition(T alg, Function2<Boolean, U, U> isLeftOf, IndexedDataSource<U> storage, long left, long right) {
        Object tmp1 = alg.construct();
        Object tmp2 = alg.construct();
        Object pivotValue = alg.construct();
        storage.get(left, pivotValue);
        long leftmark = left + 1L;
        long rightmark = right;
        boolean done = false;
        while (!done) {
            while (leftmark <= rightmark) {
                boolean isRightOf;
                storage.get(leftmark, tmp1);
                boolean bl = isRightOf = isLeftOf.call(tmp1, pivotValue) == false && isLeftOf.call(tmp1, pivotValue) != isLeftOf.call(pivotValue, tmp1);
                if (isRightOf) break;
                ++leftmark;
            }
            while (true) {
                storage.get(rightmark, tmp1);
                if (isLeftOf.call(tmp1, pivotValue).booleanValue() || rightmark < leftmark) break;
                --rightmark;
            }
            if (rightmark < leftmark) {
                done = true;
                continue;
            }
            storage.get(leftmark, tmp1);
            storage.get(rightmark, tmp2);
            storage.set(leftmark, tmp2);
            storage.set(rightmark, tmp1);
        }
        storage.get(left, tmp1);
        storage.get(rightmark, tmp2);
        storage.set(left, tmp2);
        storage.set(rightmark, tmp1);
        return rightmark;
    }

    private static <T extends Algebra<T, U>, U> void insertionSort(T alg, Function2<Boolean, U, U> isLeftOf, IndexedDataSource<U> storage, long left, long right) {
        Object key = alg.construct();
        Object tmp = alg.construct();
        Object t2 = alg.construct();
        long n = right - left + 1L;
        for (long i = 1L; i < n; ++i) {
            storage.get(left + i, key);
            long j = i - 1L;
            storage.get(left + j, tmp);
            while (j >= 0L && isLeftOf.call(key, tmp).booleanValue()) {
                storage.get(left + j, t2);
                storage.set(left + j + 1L, t2);
                if (--j < 0L) continue;
                storage.get(left + j, tmp);
            }
            storage.set(left + j + 1L, key);
        }
    }
}

