/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class Sum {
    private Sum() {
    }

    public static <T extends Algebra<T, U> & Addition<U>, U> void compute(T alg, IndexedDataSource<U> storage, U result) {
        Sum.sum(alg, 0L, storage.size(), storage, result);
    }

    private static <T extends Algebra<T, U> & Addition<U>, U> void sum(T alg, long start, long count, IndexedDataSource<U> storage, U result) {
        Object tmp1 = alg.construct();
        Object tmp2 = alg.construct();
        if (count == 0L) {
            alg.zero().call(result);
        } else if (count == 1L) {
            storage.get(start, result);
        } else if (count == 2L) {
            storage.get(start, tmp1);
            storage.get(start + 1L, tmp2);
            ((Addition<U>)alg).add().call(tmp1, tmp2, result);
        } else {
            long cnt1 = count / 2L;
            long cnt2 = count - cnt1;
            long st1 = start;
            long st2 = start + cnt1;
            Sum.sum(alg, st1, cnt1, storage, tmp1);
            Sum.sum(alg, st2, cnt2, storage, tmp2);
            ((Addition<U>)alg).add().call(tmp1, tmp2, result);
        }
    }
}

