/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class TaylorEstimateLog {
    private TaylorEstimateLog() {
    }

    public static <T extends Algebra<T, U> & Unity<U> & Multiplication<U>, U, V extends Algebra<V, W> & Addition<W> & Scale<W, U> & Invertible<W>, W> void compute(int numTerms, V elemAlgebra, T numAlgebra, W x, W result) {
        if (numTerms < 1) {
            throw new IllegalArgumentException("estimation requires 1 or more terms");
        }
        Object xMinusI = elemAlgebra.construct();
        Object xPlusI = elemAlgebra.construct();
        W I = elemAlgebra.construct(x);
        ((Unity)elemAlgebra).unity().call(I);
        ((Addition<W>)elemAlgebra).add().call(x, I, xPlusI);
        ((Addition<W>)elemAlgebra).subtract().call(x, I, xMinusI);
        W sum = elemAlgebra.construct(x);
        elemAlgebra.zero().call(sum);
        Object subTerm = elemAlgebra.construct();
        ((Invertible<W>)elemAlgebra).divide().call(xMinusI, xPlusI, subTerm);
        Object term = elemAlgebra.construct(subTerm);
        Object term2 = elemAlgebra.construct();
        Object term3 = elemAlgebra.construct();
        Object one = numAlgebra.construct();
        ((Unity<U>)numAlgebra).unity().call(one);
        Object inc = numAlgebra.construct(one);
        Object scale = numAlgebra.construct();
        for (int i = 0; i < numTerms; ++i) {
            ((Invertible)numAlgebra).divide().call(one, inc, scale);
            ((Scale<W, U>)elemAlgebra).scale().call(scale, term, term2);
            ((Addition<W>)elemAlgebra).add().call(sum, term2, sum);
            ((Multiplication)elemAlgebra).multiply().call(term, subTerm, term3);
            ((Multiplication)elemAlgebra).multiply().call(term3, subTerm, term);
            ((Addition)numAlgebra).add().call(inc, one, inc);
            ((Addition)numAlgebra).add().call(inc, one, inc);
        }
        Object two = numAlgebra.construct();
        ((Addition)numAlgebra).add().call(one, one, two);
        ((Scale<W, U>)elemAlgebra).scale().call(two, sum, sum);
        elemAlgebra.assign().call(sum, result);
    }
}

