/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class TaylorEstimateSinh {
    private TaylorEstimateSinh() {
    }

    public static <T extends Algebra<T, U> & Unity<U> & Multiplication<U>, U, V extends Algebra<V, W> & Addition<W> & Scale<W, U>, W> void compute(int numTerms, V elemAlgebra, T numAlgebra, W x, W result) {
        if (numTerms < 1) {
            throw new IllegalArgumentException("estimation requires 1 or more terms");
        }
        W sum = elemAlgebra.construct(x);
        elemAlgebra.zero().call(sum);
        W term = elemAlgebra.construct(x);
        Object term2 = elemAlgebra.construct();
        Object term3 = elemAlgebra.construct();
        Object one = numAlgebra.construct();
        ((Unity<U>)numAlgebra).unity().call(one);
        Object factorial = numAlgebra.construct(one);
        Object inc = numAlgebra.construct(one);
        Object scale = numAlgebra.construct();
        for (int i = 0; i < numTerms; ++i) {
            ((Invertible)numAlgebra).divide().call(one, factorial, scale);
            ((Scale<W, U>)elemAlgebra).scale().call(scale, term, term2);
            ((Addition<W>)elemAlgebra).add().call(sum, term2, sum);
            ((Multiplication)elemAlgebra).multiply().call(term, x, term3);
            ((Multiplication)elemAlgebra).multiply().call(term3, x, term);
            ((Addition)numAlgebra).add().call(inc, one, inc);
            ((Multiplication<U>)numAlgebra).multiply().call(factorial, inc, factorial);
            ((Addition)numAlgebra).add().call(inc, one, inc);
            ((Multiplication<U>)numAlgebra).multiply().call(factorial, inc, factorial);
        }
        elemAlgebra.assign().call(sum, result);
    }
}

