/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.TensorMember;

public class TensorCommaDerivative {
    private TensorCommaDerivative() {
    }

    public static <S extends Algebra<S, TENSOR>, TENSOR extends TensorMember<NUMBER>, M extends Algebra<M, NUMBER>, NUMBER> void compute(S tensAlg, M numAlg, Integer index, TENSOR a, TENSOR b) {
        if (a.rank() == 0) {
            tensAlg.assign().call(a, b);
            return;
        }
        TensorMember tmp = (TensorMember)tensAlg.construct();
        TensorShape.compute(a, tmp);
        Object value = numAlg.construct();
        IntegerIndex min = new IntegerIndex(a.rank());
        IntegerIndex max = new IntegerIndex(a.rank());
        IntegerIndex tmpIdx = new IntegerIndex(a.rank());
        min.set(a.rank() - 1, index.intValue());
        max.set(a.rank() - 1, index.intValue());
        for (int i = 0; i < a.rank() - 1; ++i) {
            max.set(i, a.dimension() - 1L);
        }
        SamplingCartesianIntegerGrid grid = new SamplingCartesianIntegerGrid(min, max);
        SamplingIterator<IntegerIndex> iter = grid.iterator();
        while (iter.hasNext()) {
            iter.next(tmpIdx);
            a.v(tmpIdx, value);
            tmp.setV(tmpIdx, value);
        }
        tensAlg.assign().call(tmp, b);
    }
}

