/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class TensorNorm {
    private TensorNorm() {
    }

    public static <M extends Algebra<M, NUMBER> & Norm<NUMBER, COMPONENT>, NUMBER, B extends Algebra<B, COMPONENT> & Ordered<COMPONENT> & Addition<COMPONENT> & Roots<COMPONENT>, COMPONENT> void compute(M numberAlg, B componentAlg, IndexedDataSource<NUMBER> a, COMPONENT b) {
        Object value = numberAlg.construct();
        Object max = componentAlg.construct();
        Object nrm = componentAlg.construct();
        long numElems = a.size();
        for (long i = 0L; i < numElems; ++i) {
            a.get(i, value);
            ((Norm<NUMBER, COMPONENT>)numberAlg).norm().call(value, nrm);
            if (!((Ordered<COMPONENT>)componentAlg).isGreater().call(nrm, max).booleanValue()) continue;
            componentAlg.assign().call(nrm, max);
        }
        Object sum = componentAlg.construct();
        for (long i = 0L; i < numElems; ++i) {
            a.get(i, value);
            ((Norm<NUMBER, COMPONENT>)numberAlg).norm().call(value, nrm);
            ((Invertible)componentAlg).divide().call(nrm, max, nrm);
            ((Multiplication)componentAlg).multiply().call(nrm, nrm, nrm);
            ((Addition<COMPONENT>)componentAlg).add().call(sum, nrm, sum);
        }
        ((Roots<COMPONENT>)componentAlg).sqrt().call(sum, sum);
        ((Multiplication)componentAlg).multiply().call(max, sum, sum);
        componentAlg.assign().call(sum, b);
    }
}

