/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public class TensorOuterProduct {
    private TensorOuterProduct() {
    }

    public static <S extends Algebra<S, TENSOR>, TENSOR extends TensorMember<NUMBER> & RawData<NUMBER>, M extends Algebra<M, NUMBER> & Multiplication<NUMBER>, NUMBER> void compute(S tensAlg, M numberAlg, TENSOR a, TENSOR b, TENSOR c) {
        long dimB;
        if (c == a || c == b) {
            throw new IllegalArgumentException("destination tensor cannot be one of the inputs");
        }
        long dimA = a.dimension(0);
        if (dimA != (dimB = b.dimension(0))) {
            throw new IllegalArgumentException("dimension of tensors must match");
        }
        int rankA = a.numDimensions();
        int rankB = b.numDimensions();
        int rankC = rankA + rankB;
        long[] cDims = new long[rankC];
        for (int i = 0; i < cDims.length; ++i) {
            cDims[i] = dimA;
        }
        c.alloc(cDims);
        Object aTmp = numberAlg.construct();
        Object bTmp = numberAlg.construct();
        Object cTmp = numberAlg.construct();
        IndexedDataSource<NUMBER> aList = ((RawData<NUMBER>)a).rawData();
        IndexedDataSource<NUMBER> bList = ((RawData<NUMBER>)b).rawData();
        IndexedDataSource<NUMBER> cList = ((RawData<NUMBER>)c).rawData();
        long k = 0L;
        long numElemsA = aList.size();
        long numElemsB = bList.size();
        for (long i = 0L; i < numElemsA; ++i) {
            aList.get(i, aTmp);
            for (long j = 0L; j < numElemsB; ++j) {
                bList.get(j, bTmp);
                ((Multiplication<NUMBER>)numberAlg).multiply().call(aTmp, bTmp, cTmp);
                cList.set(k, cTmp);
                ++k;
            }
        }
    }
}

