/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class TensorPower {
    private TensorPower() {
    }

    public static <S extends Algebra<S, TENSOR> & Multiplication<TENSOR>, TENSOR extends TensorMember<?>> void compute(S tensAlg, int power, TENSOR a, TENSOR b) {
        if (power < 0) {
            throw new IllegalArgumentException("negative powers not supported");
        }
        if (power == 0) {
            if (tensAlg.isZero().call(a).booleanValue()) {
                throw new IllegalArgumentException("0^0 is not a number");
            }
            TensorShape.compute(a, b);
            ((Unity)tensAlg).unity().call(b);
        } else if (power == 1) {
            tensAlg.assign().call(a, b);
        } else {
            TensorMember tmp1 = (TensorMember)tensAlg.construct();
            TensorMember tmp2 = (TensorMember)tensAlg.construct();
            ((Multiplication<TENSOR>)tensAlg).multiply().call(a, a, tmp1);
            for (int i = 2; i < power / 2 * 2; i += 2) {
                ((Multiplication<TENSOR>)tensAlg).multiply().call(tmp1, a, tmp2);
                ((Multiplication<TENSOR>)tensAlg).multiply().call(tmp2, a, tmp1);
            }
            if (power > 2 && (power & 1) == 1) {
                tensAlg.assign().call(tmp1, tmp2);
                ((Multiplication<TENSOR>)tensAlg).multiply().call(tmp2, a, tmp1);
            }
            tensAlg.assign().call(tmp1, b);
        }
    }
}

