/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.type.data.bool.BooleanMember;
import nom.bdezonia.zorbage.type.data.int1.UnsignedInt1Member;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class UInt1ToBool {
    private static Procedure2<UnsignedInt1Member, BooleanMember> converter = new Procedure2<UnsignedInt1Member, BooleanMember>(){

        @Override
        public void call(UnsignedInt1Member a, BooleanMember b) {
            b.setV(a.v() == 1);
        }
    };

    private UInt1ToBool() {
    }

    public static void compute(IndexedDataSource<UnsignedInt1Member> ints, IndexedDataSource<BooleanMember> bools) {
        long intsSize;
        long boolsSize = bools.size();
        if (boolsSize != (intsSize = ints.size())) {
            throw new IllegalArgumentException("mismatched list sizes");
        }
        Transform2.compute(G.UINT1, G.BOOL, converter, ints, bools);
    }
}

