/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class Unique {
    private Unique() {
    }

    public static <T extends Algebra<T, U>, U extends Allocatable<U>> IndexedDataSource<U> compute(T alg, IndexedDataSource<U> a) {
        Allocatable type = (Allocatable)alg.construct();
        long dupeCount = Unique.countDupes(alg, a);
        long resultSize = a.size() - dupeCount;
        IndexedDataSource<Allocatable> result = Storage.allocate(resultSize, type);
        Unique.copyWithoutDupes(alg, a, result);
        return result;
    }

    private static <T extends Algebra<T, U>, U> long countDupes(T alg, IndexedDataSource<U> a) {
        long aSize = a.size();
        if (aSize <= 1L) {
            return 0L;
        }
        Object tmp1 = alg.construct();
        Object tmp2 = alg.construct();
        a.get(0L, tmp1);
        long count = 0L;
        long ai = 1L;
        while (ai < aSize) {
            a.get(ai++, tmp2);
            if (alg.isEqual().call(tmp1, tmp2).booleanValue()) {
                ++count;
            }
            alg.assign().call(tmp2, tmp1);
        }
        return count;
    }

    private static <T extends Algebra<T, U>, U> void copyWithoutDupes(T alg, IndexedDataSource<U> a, IndexedDataSource<U> b) {
        long aSize = a.size();
        if (aSize <= 1L) {
            Copy.compute(alg, a, b);
            return;
        }
        Object tmp1 = alg.construct();
        Object tmp2 = alg.construct();
        a.get(0L, tmp1);
        b.set(0L, tmp1);
        long ai = 1L;
        long bi = 1L;
        while (ai < aSize) {
            a.get(ai++, tmp2);
            if (alg.isNotEqual().call(tmp1, tmp2).booleanValue()) {
                b.set(bi++, tmp2);
            }
            alg.assign().call(tmp2, tmp1);
        }
    }
}

